/*******************************************************
Filename	:  	DW_process_data_request.sql
Release 	:  	STORET c2.0.4, C2.0.5
SIR		:  	1631,1633
Description	:  	Process data download request by reading dw_data_requests table. 
Author	:  	Ganesh Thadkamalla
Date		: 	12/02/2004
11/10/2008 - updated for CR 25. -Jyothi
Comments	: 	This script should be run after dw_data_request table is created.
***********************************************************/
CREATE OR REPLACE PROCEDURE DW_PROCESS_DATA_REQUEST (p_req_id in number)
as

  lr_data_req dw_data_requests%rowtype;
  TYPE sds_cur IS REF CURSOR;
  sdsdata sds_cur;

  my_out_file		UTL_FILE.FILE_TYPE;
  out_file_name		VARCHAR2(30);
  iodir         		VARCHAR2(100);
  download_path 		VARCHAR2(100);
  sdrec varchar2(32000);
  lv_isn  number;
  v_zip_rc                number := 0;
  v_file_name             varchar2(200);
  v_exists 		      boolean:=FALSE;
  v_file_length 		number;
  v_blocksize 		number;
  v_time_start		number;
  v_time_current		number;
  lv_filesize_kb  number;
  lv_email_body varchar2(4000);
  lv_request_type varchar2(30);

--[META DATA]
  lv_sqlstmt       VARCHAR2(8000);
  v_mdata_filename    VARCHAR2(50);
  v_sqlstmt       VARCHAR2(2000);
  v_Stmt  VARCHAR2(8000);
  v_CursorID              INTEGER;
  v_ReturnRow             VARCHAR2(32000);
  v_Dummy                 INTEGER;
  i                       INTEGER;
  v_orgidlist             owa_util.ident_arr;
  --v_orgidlist             owa_util.vc_arr;
  lv_file_name varchar2(100);
  lv_filetype varchar2(3);
  lv_timestamp varchar2(20);
  v_filename_ts           VARCHAR2(30);

  lv_command varchar2(32000);
  lv_zipfile varchar2(200);
  lv_basefile varchar2(200);

  lv_project_blobs varchar2(30000);

  lv_reg_file varchar2(200);
  lv_bio_file varchar2(200);
  lv_hab_file varchar2(200);
  lv_stn_file varchar2(200);
  --********************************
  lv_reg_data varchar2(10);
  lv_bio_data varchar2(10);
  lv_hab_data varchar2(10);
lV_metadata varchar2(10):='DISABLE';
lv_storetzip varchar2(100):='/public/data/storpubl/storetzip';
lv_compress_ext varchar2(10):='zip';
lv_total_wait_time number;
lv_FILE_READ_WAIT_SEC number;

begin

BEGIN
  select UPPER(trim(parameter_value)) into lV_metadata
  from mt_wh_config where parameter_name = 'GV_METADATA_FLAG';
EXCEPTION WHEN OTHERS THEN
  NULL;
END;

BEGIN
  select trim(parameter_value) into lV_storetzip
  from mt_wh_config where parameter_name = 'STORETZIP';
EXCEPTION WHEN OTHERS THEN
  NULL;
END;

BEGIN
  select trim(parameter_value) into lv_compress_ext
  from mt_wh_config where parameter_name = 'GV_CMPRS_FL_EXT';
EXCEPTION WHEN OTHERS THEN
  NULL;
END;

BEGIN
  select to_number(parameter_value) into lv_FILE_READ_WAIT_SEC
  from mt_wh_config where parameter_name = 'FILE_READ_WAIT_SEC';
EXCEPTION WHEN OTHERS THEN
  NULL;
END;



select * into lr_data_req from dw_data_requests
where request_id = p_req_id;
  iodir := DW_GLOB_VAR.LV_IODIR;

  --ALLRESULTS
 -- lv_reg_data:='NO';
  --lv_bio_data:='NO';
  --lv_hab_data :='NO';
  
  lv_reg_data:=trim(lr_data_req.REG_DATA_FLAG);
  lv_bio_data:=trim(lr_data_req.BIO_DATA_FLAG);
  lv_hab_data :=trim(lr_data_req.HAB_DATA_FLAG);

  lv_basefile:=substr(lr_data_req.filename,1,instr(lr_data_req.filename,'.txt')-1);
	lv_reg_file:='Data_'||replace(lr_data_req.filename,'.txt','_RegResults.txt');
	lv_bio_file:='Data_'||replace(lr_data_req.filename,'.txt','_BioResults.txt');
	lv_hab_file:='Data_'||replace(lr_data_req.filename,'.txt','_HabResults.txt');
        lv_stn_file:='Data_'||replace(lr_data_req.filename,'.txt','_Stations.txt');
--*************
--[METADATA]
 IF lr_data_req.request_type='SDA' THEN
    --PRECCESSING REGULAR RESULT
 -- IF lv_reg_data = 'YES' THEN  
  lv_sqlstmt:=lr_data_req.RQUERY_TEXT||lr_data_req.Rquery_text2;
  v_Stmt:= substr(lv_sqlstmt,instr(upper(lv_sqlstmt),' FROM '));
  v_sqlstmt:='SELECT distinct FA.organization_id'||' '||v_Stmt;
  
  v_CursorID := DBMS_SQL.OPEN_CURSOR;
  DBMS_SQL.PARSE(v_CursorID, v_sqlstmt, DBMS_SQL.NATIVE);
  DBMS_SQL.DEFINE_COLUMN(v_CursorID, 1, v_ReturnRow, 32000);
  v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);

          i := 1;
		  --i:=v_orgidlist.last+1;
          LOOP
              IF DBMS_SQL.FETCH_ROWS(v_CursorID) = 0 THEN
	        	EXIT;
              END IF;
          DBMS_SQL.COLUMN_VALUE(v_CursorID, 1, v_ReturnRow);
          v_orgidlist(i) := v_ReturnRow;
		  --lv_reg_data:='YES';
          i :=	i+1;
          END LOOP;
          DBMS_SQL.CLOSE_CURSOR(v_CursorID);
          
 -- END IF;
 --PRECCESSING biological RESULT
 -- IF lv_bio_data = 'YES' THEN
  lv_sqlstmt:=lr_data_req.bQUERY_TEXT||lr_data_req.bquery_text2;
  v_Stmt:= substr(lv_sqlstmt,instr(upper(lv_sqlstmt),' FROM '));
  v_sqlstmt:='SELECT distinct FA.organization_id'||' '||v_Stmt;
  
  v_CursorID := DBMS_SQL.OPEN_CURSOR;
  DBMS_SQL.PARSE(v_CursorID, v_sqlstmt, DBMS_SQL.NATIVE);
  DBMS_SQL.DEFINE_COLUMN(v_CursorID, 1, v_ReturnRow, 32000);
  v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);

          --i := 1;
	-- i:=v_orgidlist.last+1;
          LOOP
              IF DBMS_SQL.FETCH_ROWS(v_CursorID) = 0 THEN
	        	EXIT;
              END IF;
            
          DBMS_SQL.COLUMN_VALUE(v_CursorID, 1, v_ReturnRow);
          dbms_output.put_line('value '||i);
          v_orgidlist(i) := v_ReturnRow;
		  --lv_bio_data:='YES';
          i :=	i+1;
          END LOOP;
          DBMS_SQL.CLOSE_CURSOR(v_CursorID);
          
  --END IF;

   --PRECCESSING habitat RESULT
  --IF lv_hab_data = 'YES' THEN
  lv_sqlstmt:=lr_data_req.hQUERY_TEXT||lr_data_req.hquery_text2;
  v_Stmt:= substr(lv_sqlstmt,instr(upper(lv_sqlstmt),' FROM '));
  v_sqlstmt:='SELECT distinct FA.organization_id'||' '||v_Stmt;

  v_CursorID := DBMS_SQL.OPEN_CURSOR;
  DBMS_SQL.PARSE(v_CursorID, v_sqlstmt, DBMS_SQL.NATIVE);
  DBMS_SQL.DEFINE_COLUMN(v_CursorID, 1, v_ReturnRow, 32000);
  v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);

          --i := 1;
	--	  i:=v_orgidlist.last+1;
          LOOP
              IF DBMS_SQL.FETCH_ROWS(v_CursorID) = 0 THEN
	        	EXIT;
              END IF;
          DBMS_SQL.COLUMN_VALUE(v_CursorID, 1, v_ReturnRow);
          v_orgidlist(i) := v_ReturnRow;
		  --lv_hab_data:='YES';
          i :=	i+1;
          END LOOP;
          DBMS_SQL.CLOSE_CURSOR(v_CursorID);          
  --END IF;
 ELSE
  if lr_data_req.query_text2 is null then
  lv_sqlstmt:=lr_data_req.QUERY_TEXT;
  else
  lv_sqlstmt:=lr_data_req.QUERY_TEXT||lr_data_req.query_text2;
  end if;

     v_Stmt:= substr(lv_sqlstmt,instr(upper(lv_sqlstmt),' FROM '));

  v_sqlstmt:='SELECT distinct FA.organization_id'||' '||v_Stmt;

  v_CursorID := DBMS_SQL.OPEN_CURSOR;
  DBMS_SQL.PARSE(v_CursorID, v_sqlstmt, DBMS_SQL.NATIVE);
  DBMS_SQL.DEFINE_COLUMN(v_CursorID, 1, v_ReturnRow, 32000);
  v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);

          i := 1;
          LOOP
              IF DBMS_SQL.FETCH_ROWS(v_CursorID) = 0 THEN
		EXIT;
              END IF;
          DBMS_SQL.COLUMN_VALUE(v_CursorID, 1, v_ReturnRow);
          v_orgidlist(i) := v_ReturnRow;
          i :=	i+1;
          END LOOP;
          DBMS_SQL.CLOSE_CURSOR(v_CursorID);
 END IF;


IF lr_data_req.request_type= 'SDA' THEN
-- Process regular results
IF lv_reg_data='YES' THEN
OPEN sdsdata FOR lr_data_req.RQUERY_TEXT||lr_data_req.rquery_text2;
  my_out_file := UTL_FILE.FOPEN(iodir,lv_reg_file,'W',30000);

  --
  UTL_FILE.PUT_LINE(my_out_file,lr_data_req.r_record_title);
  LOOP
    FETCH sdsdata INTO sdrec;
    EXIT WHEN sdsdata%NOTFOUND;
    UTL_FILE.PUT_LINE(my_out_file,sdrec);
  END LOOP;

  CLOSE sdsdata;
  UTL_FILE.FCLOSE(my_out_file);
END IF;
-- process the biological results
IF lv_bio_data='YES' THEN
OPEN sdsdata FOR lr_data_req.bQUERY_TEXT||lr_data_req.bquery_text2;
  my_out_file := UTL_FILE.FOPEN(iodir,lv_bio_file,'W',30000);
  ----
  UTL_FILE.PUT_LINE(my_out_file,lr_data_req.b_record_title);
  LOOP
    FETCH sdsdata INTO sdrec;
    EXIT WHEN sdsdata%NOTFOUND;
    UTL_FILE.PUT_LINE(my_out_file,sdrec);
  END LOOP;

  CLOSE sdsdata;
  UTL_FILE.FCLOSE(my_out_file);
END IF;
-- process the habitat results
IF lv_hab_data='YES' THEN
OPEN sdsdata FOR lr_data_req.hQUERY_TEXT||lr_data_req.hquery_text2;
  my_out_file := UTL_FILE.FOPEN(iodir,lv_hab_file,'W',30000);
  --
  UTL_FILE.PUT_LINE(my_out_file,lr_data_req.h_record_title);
  LOOP
    FETCH sdsdata INTO sdrec;
    EXIT WHEN sdsdata%NOTFOUND;
    UTL_FILE.PUT_LINE(my_out_file,sdrec);
  END LOOP;

  CLOSE sdsdata;
  UTL_FILE.FCLOSE(my_out_file);
 END IF;
ELSE
-- Process the request.
OPEN sdsdata FOR lr_data_req.QUERY_TEXT||lr_data_req.query_text2;

  iodir := DW_GLOB_VAR.LV_IODIR;

  --my_out_file := UTL_FILE.FOPEN(iodir,lr_data_req.filename,'W',30000);
  --
  --UTL_FILE.PUT_LINE(my_out_file,lr_data_req.record_title);

IF lr_data_req.request_type = 'SDS' THEN
  my_out_file := UTL_FILE.FOPEN(iodir,lv_stn_file,'W',30000);
  UTL_FILE.PUT_LINE(my_out_file,lr_data_req.record_title);
ELSIF lr_data_req.request_type = 'SDR' THEN
  my_out_file := UTL_FILE.FOPEN(iodir,lv_REG_file,'W',30000);
  UTL_FILE.PUT_LINE(my_out_file,lr_data_req.record_title);
ELSIF lr_data_req.request_type = 'SDB' THEN
  my_out_file := UTL_FILE.FOPEN(iodir,lv_BIO_file,'W',30000);
  UTL_FILE.PUT_LINE(my_out_file,lr_data_req.record_title);
ELSIF lr_data_req.request_type = 'SDH' THEN
  my_out_file := UTL_FILE.FOPEN(iodir,lv_HAB_file,'W',30000);
  UTL_FILE.PUT_LINE(my_out_file,lr_data_req.record_title);
END IF;


IF lr_data_req.request_type = 'SDS' THEN
  LOOP
    FETCH sdsdata INTO lv_isn,sdrec;
    EXIT WHEN sdsdata%NOTFOUND;
    UTL_FILE.PUT_LINE(my_out_file,sdrec);
  END LOOP;
ELSIF lr_data_req.request_type IN ('SDR','SDB','SDH') THEN
  LOOP
    FETCH sdsdata INTO sdrec;
    EXIT WHEN sdsdata%NOTFOUND;
    UTL_FILE.PUT_LINE(my_out_file,sdrec);
  END LOOP;
END IF;

  CLOSE sdsdata;
  UTL_FILE.FCLOSE(my_out_file);

END IF;  --sda

--***************************************************************************
  --[META DATA]
   v_mdata_filename := 'Data_'||replace(lr_data_req.filename,'.txt','_Metadata.txt');

    lv_zipfile:= replace(lr_data_req.filename,'.txt','.'||lv_compress_ext);

--dbms_output.put_line('starting MD procedure');
	if lr_data_req.request_type in ('SDR','SDB','SDH','SDA') THEN

  --cr_41
  IF lV_metadata= 'ENABLE' THEN
    DW_RESULT_METADATA(v_orgidlist,v_mdata_filename,lv_project_blobs);
  ELSE
     v_mdata_filename:= null;
    lv_project_blobs:=null;
  END IF;
  dbms_output.put_line('processed MD procedure');
ELSIF lr_data_req.request_type in ('SDS') THEN
  null;
END IF;

lv_command :=lv_storetzip||' '||lv_basefile;

		 dbms_output.put_line(lv_basefile);
		  dbms_output.put_line(lv_command);

		  --dw_result_download_zip(lv_command,lv_zipfile);
		  v_zip_rc := execmd(lv_command);
		     lv_total_wait_time := -1;
		  dbms_lock.sleep(lv_FILE_READ_WAIT_SEC);


  --*****
 --[META DATA]


-- check the file size

   utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,lv_zipfile,v_exists,v_file_length,v_blocksize);


   lv_total_wait_time :=lv_FILE_READ_WAIT_SEC;
   while ((not v_exists) and (lv_total_wait_time < 300 )) loop
    dbms_lock.sleep(1);
	lv_total_wait_time:=lv_total_wait_time+1;
        utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,lv_zipfile,v_exists,v_file_length,v_blocksize);
   end loop;

    IF v_exists THEN
      lv_filesize_kb:=ROUND(v_file_length/1024,1);
      dbms_output.put_line(lr_data_req.email_address);

    update dw_data_requests
    set request_status='Completed',
        filesize_kb = lv_filesize_kb,
        processed_date =sysdate
    where request_id = p_req_id;
    commit;
--select decode(lr_data_req.request_type,'SDS','Station Description','SDR','Regular Result','SDB','Biological Result','SDH','Habitat Result',lr_data_req.request_type) into lv_request_type from dual;
select decode(lr_data_req.request_type,'SDS','Station Description','SDR','Regular Result','SDB','Biological Result','SDH','Habitat Result','SDA','Results',lr_data_req.request_type) into lv_request_type from dual;

-- Email body
lv_email_body:= 'Your request for STORET '||lv_request_type||' download is completed via '||lr_data_req.request_mode||' batch processing.  The Request_ID is '||p_req_id||'.  You can download your file (size : '||lv_filesize_kb||' KB) using the hyperlink '||dw_glob_var.lv_download_path||lv_zipfile;
--lv_email_body:= 'Your request for STORET '||lv_request_type||' download is completed via '||lr_data_req.request_mode||' batch processing.  The Request_ID is '||p_req_id||'.  You can download your file (size : '||lv_filesize_kb||' KB) using the hyperlink '||dw_glob_var.lv_download_path||lv_zipfile||' '||lv_total_wait_time;

-- send an email.
    dw_mail_pkg.send
    ( p_sender_email => dw_glob_var.gv_storet_email,
       p_from => 'STORET Web Site <'||dw_glob_var.gv_storet_email||'>',
       p_to => dw_mail_pkg.array( lr_data_req.email_address),
       p_subject => 'STORET data request status (COMPLETED).  Request_ID: '||p_req_id,
       p_body => lv_email_body);

--update dw_data_requests table.
  update dw_data_requests
  set notified = 'Y',
      processed_date=sysdate
  where request_id = p_req_id;
  commit;

   END IF;
commit;

exception when others then
  update dw_data_requests
  set request_status = 'Failed',
      processed_date=sysdate
  where request_id = p_req_id;
  commit;
/*
  lv_email_body:= 'STORET Data Request processing ERROR.  The Request_ID is '||p_req_id||'.  Download file is '||dw_glob_var.lv_download_path||lv_zipfile||'.  Oracle Error message is '||sqlerrm;

-- send an email.
    dw_mail_pkg.send
    ( p_sender_email => dw_glob_var.gv_storet_email,
       p_from => 'STORET Web Site <'||dw_glob_var.gv_storet_email||'>',
       p_to => dw_mail_pkg.array( dw_glob_var.gv_storet_email),
       p_subject => '*** Error *** STORET data request processing.  Request_ID: '||p_req_id,
       p_body => lv_email_body);
	   */
  dbms_output.put_line(sqlerrm);
end;
/
show errors;